﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividualHpiiInsert]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HealthProviderIndividualHpiiInsert]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date:   07/10/2015
-- Description:   Insert a HPII for Health Provider Individual
-- =============================================

CREATE PROCEDURE [hips].[HealthProviderIndividualHpiiInsert]
(
	@HealthProviderIndividualId INT,
	@HealthProviderOrganisationNetworkId INT,
	@Hpii VARCHAR(16) = NULL,
	@HpiiLastValidatedDate DATETIME = NULL,
	@HpiiStatusId INT,
	@UserModified VARCHAR(256) 
)
AS
BEGIN
	
	SET NOCOUNT ON
	
	DECLARE @ErrorCode INT = 0,			
			@CurrentDate DATETIME = GETDATE()
	
	INSERT INTO [hips].[HealthProviderIndividualHpii]
	(	HealthProviderIndividualId,
		HealthProviderOrganisationNetworkId,
		Hpii,
		HpiiLastValidated,
		HpiiStatusId,
		DateCreated,
		UserCreated,
		DateModified,
		UserModified
	)
	VALUES
	(	@HealthProviderIndividualId,
		@HealthProviderOrganisationNetworkId,
		@Hpii,
		@HpiiLastValidatedDate,
		@HpiiStatusId,
		@CurrentDate,
		@UserModified,
		@CurrentDate,
		@UserModified
	)
	
	SELECT	@ErrorCode = @@ERROR
			
	IF @ErrorCode = 0
	BEGIN
		SELECT HealthProviderIndividualId,
               HealthProviderOrganisationNetworkId,
               Hpii,
               HpiiLastValidated,
               HpiiStatusId,
               DateCreated,
               UserCreated,
               DateModified,
               UserModified
		FROM [hips].[HealthProviderIndividualHpii]
		WHERE HealthProviderIndividualId = @HealthProviderIndividualId
	END
	
	RETURN(@ErrorCode)
	
END
GO
